unit CellPhoneMainUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, jpeg, iComponent, iVCLComponent, iCustomComponent,
  iPlotComponent, iXYPlot, FileCtrl, Menus, CPAbout, Printers, ComCtrls,
  CPMouseMeaning, ExtDlgs;

Const
  PixelMax = 2048; {compromise.  32768 hogs too much memory.  Suspect
    this may cause errors for large JPGs}
  pi = 3.14159265358979;

type
  TSpecImData = (sample, reference) ;
  pPixelArray = ^TPixelArray;
  TPixelArray = Array[0..PixelMax-1] Of TRGBTriple;
  PSpectrum = ^TSpectrum;
  Twavdom = (samplespec, referencespec, either);
  TSpectrum = record
     MinLambda, MaxLambda : real;
     xminpixel, yminpixel, xmaxpixel, ymaxpixel, pixheight, numlambda : integer;
     Wavelength : array [0..1024] of real;
     SpecInputs : array [0..6] of ^TEdit;
     Filename : string;
     Speccurrent : boolean;
     redintense,greenintense,blueintense,totalintense : array [0..1024] of double;
    end;
  TTA = record
    Minlambda, Maxlambda : real;
    numlambda : integer;
    wavelength : array [0..1024] of double;
    trans : array [0..1024] of double;
    abs : array [0..1024] of double;
   end;
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    DriveComboBox2: TDriveComboBox;
    iXYPlot1: TiXYPlot;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    Button1: TButton;
    About1: TMenuItem;
    Print1: TMenuItem;
    PrintSetup1: TMenuItem;
    OpenDialog1: TOpenDialog;
    LoadSampleLeft1: TMenuItem;
    LoadReferenceRight1: TMenuItem;
    Label1: TLabel;
    PrinterSetupDialog1: TPrinterSetupDialog;
    PrintDialog1: TPrintDialog;
    N1: TMenuItem;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    Image1: TImage;
    ScrollBox1: TScrollBox;
    DirectoryListBox2: TDirectoryListBox;
    FileListBox2: TFileListBox;
    ScrollBox2: TScrollBox;
    Image2: TImage;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Label8: TLabel;
    Edit7: TEdit;
    UpDown1: TUpDown;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Edit8: TEdit;
    Edit9: TEdit;
    Edit10: TEdit;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Edit11: TEdit;
    Edit12: TEdit;
    Edit13: TEdit;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    N2: TMenuItem;
    CSVFileExport1: TMenuItem;
    N3: TMenuItem;
    Button2: TButton;
    SaveTextFileDialog1: TSaveTextFileDialog;
    procedure About1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure PrintSetup1Click(Sender: TObject);
    procedure LoadSampleLeft1Click(Sender: TObject);
    procedure LoadReferenceRight1Click(Sender: TObject);
    procedure FileListBox1DblClick(Sender: TObject);
    procedure FileListBox2DblClick(Sender: TObject);
    procedure DirectoryListBox1DblClick(Sender: TObject);
    procedure DirectoryListBox2DblClick(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure Edit4Exit(Sender: TObject);
    procedure Edit8Exit(Sender: TObject);
    procedure Edit11Exit(Sender: TObject);
    procedure Edit2Exit(Sender: TObject);
    procedure Edit3Exit(Sender: TObject);
    procedure Edit5Exit(Sender: TObject);
    procedure Edit6Exit(Sender: TObject);
    procedure Edit7Exit(Sender: TObject);
    procedure Edit9Exit(Sender: TObject);
    procedure Edit10Exit(Sender: TObject);
    procedure Edit12Exit(Sender: TObject);
    procedure Edit13Exit(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure UpDown1ChangingEx(Sender: TObject; var AllowChange: Boolean;
      NewValue: Smallint; Direction: TUpDownDirection);
  private
    { Private declarations }
    ScratchPicture1: Tbitmap;
    ScratchPicture2: Tbitmap;
    Pic1Loaded, Pic2Loaded : boolean;
    SampleSpectrum, ReferenceSpectrum : TSpectrum;
    RatioSpec: TTA;
    procedure FormAnImage(whichone: TSpecImData);
    procedure ImageMouseClick(ActiveImage : TImage; SpectralData : PSpectrum; whichone : TSpecImData) ;
    procedure SpecAlignReconcile(whichone : TSpecImData);
    function ValIntRange(Sender: TObject; itarget, imin, imax : integer) : Boolean;
    function ValFloatRange(Sender: TObject; rtarget, rmin, rmax : real) : Boolean;
    procedure DrawSpecGuide(UnMarkedPicture : Tbitmap; DestIm : TImage; SpectralData : PSpectrum);
    procedure RawToSpec(UnmarkedPicture: Tbitmap; SpectralData : PSpectrum; whichone : TSpecImdata);
    procedure MakeTandA;
    function Pythag(ax, ay, bx, by : integer) : real;
  public
    { Public declarations }
    procedure Openfile(const filename:String; Whichone: TSpecImData);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenDialog1.Filter := GraphicFilter(TGraphic);
  FileListbox1.Mask := GraphicFileMask(TGraphic);
  FileListbox2.Mask := GraphicFileMask(TGraphic);
  Scratchpicture1:=Tbitmap.create;
  Scratchpicture2:=Tbitmap.create;
  Pic1Loaded := false;
  Pic2Loaded := false;
  SampleSpectrum.SpecInputs[0] := @Edit1;    {blue wavelength}
  SampleSpectrum.SpecInputs[1] := @Edit4;    {red wavelength}
  SampleSpectrum.SpecInputs[2] := @Edit2;    {blue x}
  SampleSpectrum.SpecInputs[3] := @Edit3;    {blue y}
  SampleSpectrum.SpecInputs[4] := @Edit5;    {red x}
  SampleSpectrum.SpecInputs[5] := @Edit6;    {red y}
  SampleSpectrum.SpecInputs[6] := @Edit7;    {height in pixels}
  SampleSpectrum.MinLambda := 400.0;
  SampleSpectrum.MaxLambda := 720.0;
  SampleSpectrum.xminpixel := 0;
  SampleSpectrum.xmaxpixel := 0;
  SampleSpectrum.yminpixel := 0;
  SampleSpectrum.ymaxpixel := 0;
  SampleSpectrum.pixheight := 1;
  SampleSpectrum.Speccurrent := false;
  ReferenceSpectrum.SpecInputs[0] := @Edit8;    {blue wavelength}
  ReferenceSpectrum.SpecInputs[1] := @Edit11;   {red wavelength}
  ReferenceSpectrum.SpecInputs[2] := @Edit9;    {blue x}
  ReferenceSpectrum.SpecInputs[3] := @Edit10;    {blue y}
  ReferenceSpectrum.SpecInputs[4] := @Edit12;    {red x}
  ReferenceSpectrum.SpecInputs[5] := @Edit13;    {red y}
  ReferenceSpectrum.SpecInputs[6] := @Edit7;    {height in pixels}
  ReferenceSpectrum.MinLambda := 400.0;
  ReferenceSpectrum.MaxLambda := 720.0;
  ReferenceSpectrum.xminpixel := 0;
  ReferenceSpectrum.xmaxpixel := 0;
  ReferenceSpectrum.yminpixel := 0;
  ReferenceSpectrum.ymaxpixel := 0;
  ReferenceSpectrum.pixheight := 1;
  ReferenceSpectrum.Speccurrent := false;
  button1.Enabled := false;
  button2.Enabled := false;
end;

function TForm1.pythag(ax, ay, bx, by : integer) : real;

var
  scratchreal : real;

begin
  scratchreal := (ax-bx)*(ax-bx) + (ay-by)*(ay-by);
  pythag := sqrt(scratchreal);
end;

procedure TForm1.Image1Click(Sender: TObject);
begin
  {Code for selecting wavelengths and x,y pairs}
  ImageMouseClick(Image1, @samplespectrum, sample);
end;

procedure TForm1.Image2Click(Sender: TObject);
begin
  {Code for selecting wavelengths and x,y pairs}
  ImageMouseClick(Image2, @referencespectrum, reference);
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  Form2.show;
end;

procedure TForm1.RawToSpec(UnmarkedPicture: Tbitmap; SpectralData : PSpectrum; whichone : TSpecImdata);

var
   cosRadians : Double;
   inX : Integer;
   inXOriginal : Integer;
   inXPrime : Integer;
   inXPrimeRotated : Integer;
   inY : Integer;
   inYOriginal : Integer;
   inYPrime : Integer;
   inYPrimeRotated : Integer;
   OriginalRow : pPixelArray;
   Radians : Double;
   RotatedRow : pPixelArray;
   sinRadians : Double;
   Center : TPoint;
   Myangle : double;
   ScratchBitmap1 : TBitmap;
   Rowmax : integer;
   sizescratch : integer;
begin
  {extract RGB and total intensity; mark that spectrum is current}
  {test bitmap type.  Allow 15, 16, 24, and 32 bit formats only}
  if (UnmarkedPicture.PixelFormat<>pf24bit) and
     (UnmarkedPicture.PixelFormat<>pf32bit) and
     (UnmarkedPicture.PixelFormat<>pf15bit) and
     (UnmarkedPicture.PixelFormat<>pf16bit) then
     begin
       showmessage('JPG pixel format not 15, 16, 24, or 32 bit.  Can not process data.');
     end
  else
    begin
    {rotate and translate spectrum to edge of scratch bitmap
     to avoid suscript problems, scratch copy of image with dimensions
     2 pixels bigger than opposite corner distance.}
    Try
      Scratchbitmap1 := tbitmap.Create;
      {rotate about blue end of spectrum}
      center.x := Spectraldata.xminpixel;
      center.Y := Spectraldata.yminpixel;
      Myangle := arctan((spectraldata.ymaxpixel-spectraldata.yminpixel)/(spectraldata.xmaxpixel-spectraldata.xminpixel));
      IF Spectraldata.xminpixel<Spectraldata.xmaxpixel then
        begin
          Myangle:=Myangle-pi/2;
        end
      else
        If Spectraldata.xminpixel>Spectraldata.xmaxpixel then
          Myangle := Myangle + pi/2
            else
              If Spectraldata.yminpixel>Spectraldata.ymaxpixel then
                Myangle := pi
                  else Myangle := 0;
      sizescratch := 2 + round(pythag(0,0,UnmarkedPicture.width,UnmarkedPicture.height));
      scratchBitmap1.Width := sizescratch;
      scratchBitmap1.Height := sizescratch;
      scratchBitmap1.PixelFormat := pf24bit;
      sinRadians := Sin(Myangle) ;
      cosRadians := Cos(Myangle) ;
      For inX := scratchbitmap1.Height-1 Downto 0 Do      {for wide raw image, scan gets truncated  used to be unmarkedpicture.}
        Begin
          RotatedRow := scratchBitmap1.Scanline[inX];
          inXPrime := 2*(inX - Center.y) + 1;
          For inY := scratchbitmap1.Width-1 Downto 0 Do   {bug must be in here ... }
            Begin
               inYPrime := 2*(inY - Center.x) + 1;
               inYPrimeRotated := Round(inYPrime * CosRadians - inXPrime * sinRadians) ;
               inXPrimeRotated := Round(inYPrime * sinRadians + inXPrime * cosRadians) ;
               inYOriginal := (inYPrimeRotated - 1) Div 2 + Center.x;
               inXOriginal := (inXPrimeRotated - 1) Div 2 + Center.y;
               If
                 (inYOriginal >= 0) And
                 (inYOriginal <= UnmarkedPicture.Width-1) And
                 (inXOriginal >= 0) And
                 (inXOriginal <= UnmarkedPicture.Height-1)
               Then
                 Begin
                   OriginalRow := UnmarkedPicture.Scanline[inXOriginal];
                   RotatedRow[inY] := OriginalRow[inYOriginal]
                 End
               else
                 begin
                   RotatedRow[inY].rgbtBlue := 0;
                   RotatedRow[inY].rgbtGreen := 0;
                   RotatedRow[inY].rgbtRed := 0
                 end;
            End;
        End;
    {Info is rotated. Minimum row = spectrum.yminpixel}
      rowmax := spectraldata.yminpixel + Round(pythag(spectraldata.xminpixel, spectraldata.yminpixel, spectraldata.xmaxpixel, spectraldata.ymaxpixel));
      if Rowmax>scratchbitmap1.height then
        begin
          rowmax := scratchbitmap1.height;
          showmessage('WARNING!! Because of spectrum location in picture, data have been truncated during processing.');
        end;
    {For each row, sum intensities in each RGB channel and assign wavelength}
    Inyoriginal := spectraldata.xminpixel-spectraldata.pixheight div 2;
    Inyprime := spectraldata.xminpixel+spectraldata.pixheight div 2;
    if Inyoriginal<0 then Inyoriginal :=0;
    if inyprime>scratchbitmap1.width then inyprime := scratchbitmap1.width;
    for Inx := 0 to Length(spectraldata.wavelength) - 1 do
          spectraldata.wavelength[Inx]:=0;       {added to avoid seeing leftovers from earlier, longer spectra when recomputing}
    spectraldata.numlambda := rowmax - spectraldata.yminpixel+1;
    for Inx := spectraldata.yminpixel to rowmax do
      begin
        OriginalRow := scratchbitmap1.Scanline[inX];
        Spectraldata.RedIntense[Inx-spectraldata.yminpixel] := 0;
        Spectraldata.GreenIntense[Inx-spectraldata.yminpixel] := 0;
        Spectraldata.BlueIntense[Inx-spectraldata.yminpixel] := 0;
        Spectraldata.totalintense[Inx-spectraldata.yminpixel] := 0;
        spectraldata.Wavelength[Inx-spectraldata.yminpixel] := spectraldata.MinLambda +
            (spectraldata.MaxLambda-spectraldata.minlambda)*(Inx-spectraldata.yminpixel)/spectraldata.numlambda;
        for Iny := inyoriginal to inyprime do
           begin
              spectraldata.RedIntense[Inx-spectraldata.yminpixel] := spectraldata.RedIntense[Inx-spectraldata.yminpixel]+  Originalrow[iny].rgbtRed;
              spectraldata.GreenIntense[Inx-spectraldata.yminpixel] := spectraldata.GreenIntense[Inx-spectraldata.yminpixel] + Originalrow[iny].rgbtGreen;
              spectraldata.BlueIntense[Inx-spectraldata.yminpixel] := spectraldata.BlueIntense[Inx-spectraldata.yminpixel] + Originalrow[iny].rgbtBlue;
            end;
            spectraldata.totalintense[Inx-spectraldata.yminpixel] := spectraldata.Redintense[Inx-spectraldata.yminpixel]
             + spectraldata.GreenIntense[Inx-spectraldata.yminpixel] + spectraldata.BlueIntense[Inx-spectraldata.yminpixel];
      end;
    Finally
       scratchbitmap1.free;
    End;
    end;
end;

procedure TForm1.MakeTandA;

var
  scratchint1, scratchint2, i, j, k, ifirst, ilast : integer;
  dominantspec : Twavdom ;
  foundblock : Boolean;

begin
{Need a different strategy.  Translate I(lambda) into spline and ratio the splines?}
{Hunch: overextended plots are due to plotting of previous, longer data.  Maybe empty ratiospec.T and A before each computation?}
    IF samplespectrum.MinLambda>referencespectrum.MinLambda then ratiospec.minlambda := samplespectrum.MinLambda
      else ratiospec.minlambda := referencespectrum.MinLambda;
    IF samplespectrum.maxlambda<referencespectrum.MaxLambda then ratiospec.maxlambda := samplespectrum.MaxLambda
      else ratiospec.maxlambda := referencespectrum.MaxLambda;
    if ((ratiospec.Maxlambda - ratiospec.minlambda)<2) then
      begin
        showmessage('Overlapping wavelength range of sample and reference < 2 nm.  No computation of transmission or absorption spectrum.');
      end
     else
       begin
         scratchint1 := 0;
         scratchint2 := 0;
         for i := 0 to Length(samplespectrum.Wavelength)-1 do
             if (samplespectrum.Wavelength[i]>=ratiospec.minlambda) and (samplespectrum.Wavelength[i]<=ratiospec.maxlambda) then
                scratchint1 := scratchint1+1;
         for i := 0 to Length(referencespectrum.Wavelength)-1 do
             if (referencespectrum.Wavelength[i]>=ratiospec.minlambda) and (referencespectrum.Wavelength[i]<=ratiospec.maxlambda) then
                scratchint2 := scratchint2+1;
         i := 0;
         foundblock := false;
         if scratchint1>scratchint2 then
           begin
             ratiospec.numlambda := scratchint2;
             dominantspec := samplespec ;
             {set min and max pixels for spectrum}
             repeat
               if ABS(samplespectrum.wavelength[i]-samplespectrum.MinLambda)<0.01 then
                    begin
                      ifirst := i;
                      ilast := ratiospec.numlambda + i - 1;
                      foundblock := true;
                    end
                  else
                    begin
                      i := i+1;
                    end;
             until foundblock OR (samplespectrum.wavelength[i]-samplespectrum.MinLambda>0.02);
           end
          else if scratchint2>scratchint1 then
             begin
               ratiospec.numlambda := scratchint1;
               dominantspec := referencespec;
             {set min and max pixels for spectrum}
             repeat
               if ABS(referencespectrum.wavelength[i]-referencespectrum.MinLambda)<0.01 then
                    begin
                      ifirst := i;
                      ilast := ratiospec.numlambda + i - 1;
                      foundblock := true;
                    end
                  else
                    begin
                      i := i+1;
                    end;
             until foundblock OR (referencespectrum.wavelength[i]-referencespectrum.MinLambda>0.02);
             end
           else
             begin
               Ratiospec.numlambda := scratchint1;
               dominantspec := either;
             {set min and max pixels for spectrum}
               repeat
                 if ABS(referencespectrum.wavelength[i]-referencespectrum.MinLambda)<0.01 then
                    begin
                      ifirst := i;
                      ilast := ratiospec.numlambda + i - 1;
                      foundblock := true;
                    end
                  else
                    begin
                      i := i+1;
                    end;
               until foundblock OR (referencespectrum.wavelength[i]-referencespectrum.MinLambda>0.02);
             end  ;
           {if foundblock do the following; not yet revised in light of fixes above}
           if foundblock then
             begin
           case dominantspec of
             samplespec: begin
               k := 0;
               while (samplespectrum.Wavelength[k]-referencespectrum.Wavelength[ifirst])<0 do
                  k := k+1;
               for j := ifirst to ilast do
                  begin
                    if (samplespectrum.Wavelength[k]-referencespectrum.Wavelength[ifirst])<0 then
                       while (samplespectrum.Wavelength[k]-referencespectrum.Wavelength[j])<0 do
                          k := k+1;
                    if referencespectrum.totalintense[j]<1E-50 then
                      referencespectrum.totalintense[j]:= 0.01;
                    if (samplespectrum.Wavelength[k]-samplespectrum.wavelength[k-1]=0) then
                       showmessage('Two adjacent sample spectrum wavelengths are identical.');
                    If (abs(samplespectrum.Wavelength[k]-referencespectrum.wavelength[j])<0.01) then
                      ratiospec.trans[j-ifirst] := samplespectrum.totalintense[k]/referencespectrum.totalintense[i] else
                      ratiospec.trans[j-ifirst] := (samplespectrum.totalintense[k-1] +
                      (samplespectrum.totalintense[k]-samplespectrum.totalintense[k-1])
                      *(referencespectrum.wavelength[j]-samplespectrum.wavelength[k-1])/
                      (samplespectrum.wavelength[k]-samplespectrum.wavelength[k-1]))/referencespectrum.totalintense[j];
                    ratiospec.wavelength[j-ifirst] := referencespectrum.Wavelength[j];
                    if ratiospec.trans[j-ifirst]>0 then ratiospec.abs[j-ifirst] := -ln(ratiospec.trans[j-ifirst])/ln(10)
                      else ratiospec.abs[j-ifirst] := -0.12345;
                  end;
               end;
             referencespec:  begin
               k := 0;
               while (referencespectrum.Wavelength[k]-samplespectrum.Wavelength[ifirst])<0 do
                  k := k+1;
               for j := ifirst to ilast do
                  begin
                    if (referencespectrum.Wavelength[k]-samplespectrum.Wavelength[ifirst])<0 then
                       while (referencespectrum.Wavelength[k]-samplespectrum.Wavelength[j])<0 do
                          k := k+1;
                    If (abs(referencespectrum.Wavelength[k]-samplespectrum.wavelength[j])<0.01) then
                      ratiospec.trans[j-ifirst] := samplespectrum.totalintense[j]/referencespectrum.totalintense[k] else
                      ratiospec.trans[j-ifirst] := samplespectrum.totalintense[j]/(referencespectrum.totalintense[k-1]
                      +(referencespectrum.totalintense[k]-referencespectrum.totalintense[k-1]) * (samplespectrum.wavelength[j]-referencespectrum.wavelength[k-1])/
                      (referencespectrum.wavelength[k]-referencespectrum.wavelength[k-1]));
                    ratiospec.wavelength[j-ifirst] := samplespectrum.Wavelength[j];
                    if ratiospec.trans[j-ifirst]>0 then ratiospec.abs[j-ifirst] := -ln(ratiospec.trans[j-ifirst])/ln(10)
                      else ratiospec.abs[j-ifirst] := -0.12345;
                  end;
               end;
             either:  begin
                 for j := ifirst to ilast do
                   begin
                      ratiospec.wavelength[j-ifirst] := samplespectrum.wavelength[j];    {bug!! start at minlambda, not j=0!}
                      IF referencespectrum.totalintense[j]>0 then
                        ratiospec.trans[j-ifirst] := samplespectrum.totalintense[j]/referencespectrum.totalintense[j]
                        else ratiospec.trans[j-ifirst] := 2.00;
                      if ratiospec.trans[j-ifirst]>0 then ratiospec.abs[j-ifirst] := -ln(ratiospec.trans[j-ifirst])/ln(10)
                        else ratiospec.abs[j-ifirst] := -0.12345;
                   end;
                 end;
           end;
             end
           else
               showmessage('Inconsistent spectral data; could not compute transmittance or absorbance.');
       end;
end;

procedure TForm1.Button1Click(Sender: TObject);

var
  i, scratchint1, scratchint2 : integer;
  specdirec : integer; {2 means illegal}
  scratchreal1, scratchreal2 : real;
  SkipPlot : boolean;
{Plot Spectral Data}
begin
  SkipPlot := false;
  IF radiogroup1.itemindex <>2 then SpecAlignReconcile(sample);
  if radiogroup1.itemindex <>1 then SpecAlignReconcile(reference);
    {1) extract pixels and make intensity arrays as f(pixel)
     2) if warranted, intensity as f(wavelength)
     3) if warranted, compute T
     4) if warranted, compute A}
  If pic1loaded then  RawToSpec(scratchpicture1, @SampleSpectrum, sample);
  If pic2loaded then  RawToSpec(scratchpicture2, @ReferenceSpectrum, reference);
  if pic1loaded and pic2loaded then MakeTandA;
  case Radiogroup2.ItemIndex of {Label x axis}
     0 : begin  {Abscissa = pixel number}
       ixyplot1.XAxis[0].Title := 'Pixel';
       scratchint1 := 10000;
       scratchint2 := 0;
       With referencespectrum do
         begin
           begin
             if (xmaxpixel=xminpixel) and (ymaxpixel=yminpixel) then
               specDirec := 2
               else SpecDirec := 1;
           end;
         end;
       if specDirec<>2 then
         if (samplespectrum.xmaxpixel = samplespectrum.xminpixel) and
            (samplespectrum.ymaxpixel = samplespectrum.yminpixel) then
             specDirec := 2;
       case Specdirec of
         1 : begin
              scratchreal1 := pythag(samplespectrum.xminpixel,samplespectrum.yminpixel, samplespectrum.xmaxpixel, samplespectrum.ymaxpixel);
              scratchint1 := round(sqrt(scratchreal1));
              scratchreal1 := pythag(referencespectrum.xminpixel,referencespectrum.yminpixel, referencespectrum.xmaxpixel, referencespectrum.ymaxpixel);
              scratchint2 := round(sqrt(scratchreal1));
              IF scratchint1>scratchint2 then scratchint2 := scratchint1;
              scratchint1 := 0;
           end;
         2 : begin
             showmessage('Scale parameters must allow a finite range of pixels or wavelengths to be displayed.'
             +'  Please assign spectral range.');
             ixyPlot1.Xaxis[0].Min := 0;
             ixyPlot1.XAxis[0].Span := 100;
             ixyPlot1.XAxis[0].DesiredIncrement := 20;
             SkipPlot := true;
             ixyplot1.XAxis[0].TitleShow := false;
          end;
         end;
       If specdirec<>2 then begin
         ixyPlot1.XAxis[0].Min := scratchint1;
         ixyPlot1.Xaxis[0].Span := scratchint2-scratchint1;
         ixyPlot1.Xaxis[0].DesiredIncrement := (scratchint2-scratchint1)/5;
       end;
       end;
     1 : begin   {Abscissa = wavelength}
       ixyplot1.XAxis[0].Title := 'Wavelength (nm)';
       scratchreal1 := referencespectrum.MinLambda;
       scratchreal2 := referencespectrum.MaxLambda;
       if samplespectrum.MinLambda<scratchreal1 then scratchreal1 := samplespectrum.MinLambda;
       if samplespectrum.maxlambda>scratchreal2 then scratchreal2 := samplespectrum.maxlambda;
       if ABS(scratchreal1 - scratchreal2)<0.1 then
         begin
           showmessage('Maximum and minimum wavelengths must be different.');
           skipplot := true;
         end
       else
         begin
           ixyplot1.Xaxis[0].Min := scratchreal1;
           ixyplot1.XAxis[0].Span := scratchreal2 - scratchreal1;
           ixyplot1.XAxis[0].Desiredincrement := (scratchreal2-scratchreal1)/5
         end;
     end;
  end;
  if ((Radiogroup1.ItemIndex>1) and not pic2loaded) or
     ((Radiogroup1.ItemIndex<>2) and not pic1loaded) then skipplot := true;
  if not skipplot then
    begin
    ixyplot1.xaxis[0].TitleShow := true;
    if radiogroup1.itemindex<3 then
      begin
        scratchreal1 := 0;
        for i  := 0 to samplespectrum.numlambda-1 do
           if samplespectrum.totalintense[i]>scratchreal1 then scratchreal1 := samplespectrum.totalintense[i];
        for i := 0 to referencespectrum.numlambda - 1 do
           if referencespectrum.totalintense[i]>scratchreal1 then scratchreal1 := referencespectrum.totalintense[i];
        scratchreal2 := round(exp(round(ln(scratchreal1)+0.5)));
        ixyplot1.YAxis[0].span := scratchreal2;
      end;
    For i := 0 to 7 do
      IF ixyplot1.Channel[i].count>0 then ixyplot1.Channel[i].DeletePoints(ixyplot1.Channel[i].Count);
    {set channel labels}
    ixyplot1.Legend[0].Visible := true;
    case radiogroup1.itemindex of
      0 : begin
        ixyplot1.Channel[0].TitleText := 'Sample Red I';
        ixyplot1.Channel[1].TitleText := 'Sample Green I';
        ixyplot1.Channel[2].TitleText := 'Sample Blue I';
        ixyplot1.Channel[3].TitleText := 'Sample Intensity';
        for i := 0 to 3 do
          begin
            ixyplot1.Channel[i].Visible := true;
            ixyplot1.Channel[i].VisibleInLegend := true;
            ixyplot1.Channel[i+4].visible := false;
            ixyplot1.Channel[i+4].VisibleInLegend := false;
          end;
      end;
      1 : begin
        ixyplot1.Channel[4].TitleText := 'Reference Red I';
        ixyplot1.Channel[5].TitleText := 'Reference Green I';
        ixyplot1.Channel[6].TitleText := 'Reference Blue I';
        ixyplot1.Channel[7].TitleText := 'Reference Intensity';
        for i := 4 to 7 do
          begin
            ixyplot1.Channel[i].Visible := true;
            ixyplot1.Channel[i].VisibleInLegend := true;
            ixyplot1.Channel[i-4].visible := false;
            ixyplot1.Channel[i-4].VisibleInLegend := false;
          end;
      end;
      2 : begin
        ixyplot1.Channel[0].TitleText := 'Sample Red I';
        ixyplot1.Channel[1].TitleText := 'Sample Green I';
        ixyplot1.Channel[2].TitleText := 'Sample Blue i';
        ixyplot1.Channel[3].TitleText := 'Sample Total Intensity';
        ixyplot1.Channel[4].TitleText := 'Reference Red I';
        ixyplot1.Channel[5].TitleText := 'Reference Green I';
        ixyplot1.Channel[6].TitleText := 'Reference Blue i';
        ixyplot1.Channel[7].TitleText := 'Reference Total Intensity';
        for i := 0 to 7 do
          begin
            ixyplot1.Channel[i].Visible := true;
            ixyplot1.Channel[i].VisibleInLegend := true;
          end
      end;
      3 : begin
        ixyplot1.yaxis[0].title := 'Transmittance';
        ixyplot1.Channel[0].Visible := true;
        ixyplot1.Channel[0].VisibleInLegend := false;
        ixyplot1.yaxis[0].Min := 0;
        ixyplot1.yaxis[0].Span := 1;
        for i := 1 to 7 do
           begin
             ixyplot1.Channel[i].Visible := false;
             ixyplot1.Channel[i].VisibleInLegend := false;
           end;
        ixyplot1.Legend[0].Visible := false;
      end;
      4 : begin
        ixyplot1.yaxis[0].Title := 'Absorbance';
        ixyplot1.Channel[0].Visible := true;
        ixyplot1.Channel[0].VisibleInLegend := false;
        ixyplot1.yaxis[0].Min := 0;
        ixyplot1.yaxis[0].Span := 2;
        for i := 1 to 7 do
           begin
             ixyplot1.Channel[i].Visible := false;
             ixyplot1.Channel[i].VisibleInLegend := false;
           end;
        ixyplot1.Legend[0].Visible := false;
      end;
    end;
    case Radiogroup1.Itemindex of {Label y axis}
     0, 1, 2 : begin  {Raw intensity}
       ixyplot1.YAxis[0].Title := 'Intensity';
     end;
     3 : begin  {Transmittance}
       ixyplot1.YAxis[0].Title := 'Transmittance';
     end;
     4 : begin  {Absorbance}
       ixyplot1.YAxis[0].Title := 'Absorbance';
     end;
    end;
    ixyplot1.yaxis[0].Titleshow := true;
    {Insert actually plotting here.  All x,y vectors empty}
     case radiogroup1.itemindex of
     0 :   begin {sample intensity}
             for i := 0 to samplespectrum.numlambda-1 do
               begin
                 if radiogroup2.itemindex=0 then
                    begin
                       scratchreal1 := i;
                       ixyplot1.channel[0].AddXY(double(scratchreal1),double(samplespectrum.redintense[i]));
                       ixyplot1.channel[1].AddXY(double(scratchreal1),double(samplespectrum.greenintense[i]));
                       ixyplot1.channel[2].AddXY(double(scratchreal1),double(samplespectrum.blueintense[i]));
                       ixyplot1.channel[3].AddXY(double(scratchreal1),double(samplespectrum.totalintense[i]));
                    end
                    else
                    begin
                       ixyplot1.channel[0].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.redintense[i]));
                       ixyplot1.channel[1].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.greenintense[i]));
                       ixyplot1.channel[2].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.blueintense[i]));
                       ixyplot1.channel[3].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.totalintense[i]));
                    end;
               end;
           end;
     1 :   begin {reference intensity}
             for i := 0 to referencespectrum.numlambda-1 do
               begin
                 if radiogroup2.itemindex=0 then
                    begin
                       scratchreal1 := i;
                       ixyplot1.channel[4].AddXY(double(scratchreal1),double(referencespectrum.redintense[i]));
                       ixyplot1.channel[5].AddXY(double(scratchreal1),double(referencespectrum.greenintense[i]));
                       ixyplot1.channel[6].AddXY(double(scratchreal1),double(referencespectrum.blueintense[i]));
                       ixyplot1.channel[7].AddXY(double(scratchreal1),double(referencespectrum.totalintense[i]));
                    end
                    else
                    begin
                       ixyplot1.channel[4].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.redintense[i]));
                       ixyplot1.channel[5].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.greenintense[i]));
                       ixyplot1.channel[6].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.blueintense[i]));
                       ixyplot1.channel[7].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.totalintense[i]));
                    end;
               end;
           end;
     2 :   begin {both}
             for i := 0 to samplespectrum.numlambda-1 do
               begin
                 if radiogroup2.itemindex=0 then
                    begin
                       scratchreal1 := i;
                       ixyplot1.channel[0].AddXY(double(scratchreal1),double(samplespectrum.redintense[i]));
                       ixyplot1.channel[1].AddXY(double(scratchreal1),double(samplespectrum.greenintense[i]));
                       ixyplot1.channel[2].AddXY(double(scratchreal1),double(samplespectrum.blueintense[i]));
                       ixyplot1.channel[3].AddXY(double(scratchreal1),double(samplespectrum.totalintense[i]));
                    end
                    else
                    begin
                       ixyplot1.channel[0].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.redintense[i]));
                       ixyplot1.channel[1].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.greenintense[i]));
                       ixyplot1.channel[2].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.blueintense[i]));
                       ixyplot1.channel[3].AddXY(double(samplespectrum.Wavelength[i]),double(samplespectrum.totalintense[i]));
                    end;
               end;
             for i := 0 to referencespectrum.numlambda-1 do
               begin
                 if radiogroup2.itemindex=0 then
                    begin
                       scratchreal1 := i;
                       ixyplot1.channel[4].AddXY(double(scratchreal1),double(referencespectrum.redintense[i]));
                       ixyplot1.channel[5].AddXY(double(scratchreal1),double(referencespectrum.greenintense[i]));
                       ixyplot1.channel[6].AddXY(double(scratchreal1),double(referencespectrum.blueintense[i]));
                       ixyplot1.channel[7].AddXY(double(scratchreal1),double(referencespectrum.totalintense[i]));
                    end
                    else
                    begin
                       ixyplot1.channel[4].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.redintense[i]));
                       ixyplot1.channel[5].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.greenintense[i]));
                       ixyplot1.channel[6].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.blueintense[i]));
                       ixyplot1.channel[7].AddXY(double(referencespectrum.Wavelength[i]),double(referencespectrum.totalintense[i]));
                    end;
               end;
           end;
     3 :   begin {Transmittance}
             for i := 0 to ratiospec.numlambda-1 do
                begin
                   ixyplot1.channel[0].AddXY(double(ratiospec.wavelength[i]),ratiospec.trans[i]);
                end;
           end;
     4 :   begin {Absorbance}
             for i := 0 to ratiospec.numlambda-1 do
                begin
                   ixyplot1.channel[0].AddXY(double(ratiospec.wavelength[i]),ratiospec.abs[i]);
                end;
           end;
     end;
    end;
end;

procedure TForm1.Button2Click(Sender: TObject);

{Export data to .CSV file}

var
  i, maxpts : integer;
  CSVOutput :  textfile;

begin
  SaveTextFileDialog1.DefaultExt := 'CSV';
  IF SaveTextFileDialog1.Execute then
    begin
      {$I-}
      Assignfile(CSVoutput, savetextfiledialog1.FileName);
      Reset(CSVoutput);
      if Ioresult<>0 then
        rewrite(CSVoutput) else append(CSVoutput);
      {$I+}
      {if exists, append, otherwise reset}
  {Output header information: file names, extraction parameters
   List column 1-2 = pixel number and wavelength, sample
   Column 3-6 = I(red), I(green), I(blue), I(total)
   column 7-8 = pixel number and wavelength, reference
   column 9-12 = I(red), I(green), I(blue), I(total)
   Column 13-15 = wavelength, T, and A
   Any missing data show as "MD"}
       maxpts := samplespectrum.numlambda;
       if referencespectrum.numlambda>samplespectrum.numlambda then
          maxpts := referencespectrum.numlambda;
       Write(CSVoutput,'pixel number, wavelength, Isample(red), Isample(green), Isample(blue), Isample(total), ');
       Write(CSVoutput,'pixel number, wavelength, Iref(red), Iref(green), Iref(blue), Iref(total), ');
       Writeln(CSVoutput, 'wavelength, Transmittance, Absorbance');
       for i := 0 to maxpts do
           begin
             if i<samplespectrum.numlambda then
               begin
                 Write(CSVoutput,InttoStr(i),',',FloattoStr(samplespectrum.Wavelength[i]),',',
                   floattoStr(samplespectrum.redintense[i]),',',floattoStr(samplespectrum.greenintense[i]),',',
                   floattoStr(samplespectrum.blueintense[i]),',',floattoStr(samplespectrum.totalintense[i]),',');
               end
             else
               begin
                 Write(CSVoutput,' , , , , , ,');
               end;
             if i<referencespectrum.numlambda then
               begin
                 Write(CSVoutput,InttoStr(i),',',FloattoStr(referencespectrum.Wavelength[i]),',',
                   floattoStr(referencespectrum.redintense[i]),',',floattoStr(referencespectrum.greenintense[i]),',',
                   floattoStr(referencespectrum.blueintense[i]),',',floattoStr(referencespectrum.totalintense[i]),',');
               end
             else
               begin
                 Write(CSVoutput,' , , , , , ,');
               end;
             if i<ratiospec.numlambda then
               begin
                 Writeln(CSVoutput, floattostr(ratiospec.wavelength[i]),',', floattostr(ratiospec.trans[i]),',',
                   floattostr(ratiospec.abs[i]));
               end
             else
               begin
                 Writeln(CSVoutput,' , , ');
               end;
           end;
       Flush(CSVoutput);
       Closefile(CSVOutput);
    end;
  ShowMessage('Output data reflect most recent plot.');
end;

procedure TForm1.DirectoryListBox1DblClick(Sender: TObject);
begin
  Opendialog1.Filter := 'JPeg Files (*.JPG) | *.JPG';
  If OpenDialog1.Execute then
    begin
      OpenFile(OpenDialog1.filename, Sample);
      Samplespectrum.filename := OpenDialog1.filename;
    end;
end;

procedure TForm1.DirectoryListBox2DblClick(Sender: TObject);
begin
  Opendialog1.Filter := 'JPeg Files (*.JPG) | *.JPG';
  If OpenDialog1.Execute then
    begin
      OpenFile(Opendialog1.filename, Reference);
      Referencespectrum.filename := Opendialog1.filename;
    end;
end;

procedure TForm1.Edit10Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, referenceSpectrum.yminpixel, 0, Image2.Height) then
    formanimage(reference)
  else
    Edit10.SetFocus;
end;

procedure TForm1.Edit11Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  IF ValfloatRange(Sender, ReferenceSpectrum.MaxLambda, strtofloat(Edit8.text)+1, 999.9) then
     formanimage(reference)
  else
    begin
      Edit11.SetFocus;
    end;
end;

procedure TForm1.Edit12Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, referenceSpectrum.xmaxpixel, 0, Image2.Width) then
    formanimage(reference)
  else
    Edit12.SetFocus;
end;

procedure TForm1.Edit13Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, referenceSpectrum.ymaxpixel, 0, Image2.Height) then
    formanimage(reference)
  else
    Edit13.SetFocus;
end;

procedure TForm1.Edit1Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  IF ValfloatRange(Sender, SampleSpectrum.MinLambda, 200.0, strtofloat(Edit4.text)-1) then
     formanimage(sample)
  else
    begin
      Edit1.SetFocus;
    end;
end;

procedure TForm1.Edit2Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, SampleSpectrum.xminpixel, 0, Image1.Width) then
    formanimage(sample)
  else
    Edit2.SetFocus;
end;

procedure TForm1.Edit3Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, SampleSpectrum.yminpixel, 0, Image1.Height) then
    formanimage(sample)
  else
    Edit3.SetFocus;
end;

procedure TForm1.Edit4Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  IF ValfloatRange(Sender, SampleSpectrum.MaxLambda, strtofloat(Edit1.text)+1, 999.9) then
     formanimage(sample)
  else
    begin
      Edit4.SetFocus;
    end;
end;

procedure TForm1.Edit5Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, SampleSpectrum.xmaxpixel, 0, Image1.Width) then
    formanimage(sample)
  else
    Edit5.SetFocus;
end;

procedure TForm1.Edit6Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, SampleSpectrum.ymaxpixel, 0, Image1.Height) then
    formanimage(sample)
  else
    Edit6.SetFocus;
end;

procedure TForm1.Edit7Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, SampleSpectrum.pixheight, 1, 99) then
    begin
      ReferenceSpectrum.pixheight := STRtoINT(Edit7.text) ;
      SampleSpectrum.pixheight := ReferenceSpectrum.pixheight;
      formanimage(sample);
      formanimage(reference);
    end
  else
    Edit7.SetFocus;
end;

procedure TForm1.Edit8Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  IF ValfloatRange(Sender, ReferenceSpectrum.MinLambda, 200.0, strtofloat(Edit11.text)-1) then
     formanimage(reference)
  else
    begin
      Edit8.SetFocus;
    end;
end;

procedure TForm1.Edit9Exit(Sender: TObject);
begin
  {check validity and, if OK, update field}
  if valintrange(Sender, referenceSpectrum.xminpixel, 0, Image2.Width) then
    formanimage(reference)
  else
    Edit9.SetFocus;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
  Application.Terminate;
end;

procedure TForm1.FileListBox1DblClick(Sender: TObject);
begin
  OpenFile(FileListbox1.Filename, Sample); {need to send filename to OpenFile}
  Samplespectrum.filename := FileListbox1.Filename;
end;

procedure TForm1.FileListBox2DblClick(Sender: TObject);
begin
  OpenFile(FileListbox2.Filename, Reference);
  Referencespectrum.filename := FileListbox2.Filename;
end;

procedure TForm1.LoadReferenceRight1Click(Sender: TObject);
begin
  Opendialog1.Filter := 'JPeg Files (*.JPG) | *.JPG';
  If OpenDialog1.Execute then
    begin
      Openfile(Opendialog1.FileName, Reference);
      Referencespectrum.filename := Opendialog1.FileName;
    end;
end;

procedure TForm1.LoadSampleLeft1Click(Sender: TObject);
begin
  Opendialog1.Filter := 'JPeg Files (*.JPG) | *.JPG';
  If OpenDialog1.Execute then
    begin
      Openfile(Opendialog1.Filename, Sample);
      samplespectrum.filename := Opendialog1.Filename;
    end;
end;

procedure Tform1.ImageMouseClick(ActiveImage : TImage; SpectralData : PSpectrum; whichone : TSpecImData) ;

Var
  localclicktype : TSpecButVal ;
  Mouselocale, ScrollMove : Tpoint;
  BitMapImage : Tbitmap;
  TempModal : TModalresult;

begin
   {initial origin is upper left corner of screen}
   GetCursorPos(MouseLocale);
   {switch origin to scrollbox origin}
   Mouselocale := ScreenToClient(Mouselocale);
   case whichone of
     sample: begin
        scrollmove.x := scrollbox1.HorzScrollBar.scrollpos-scrollbox1.left;
        scrollmove.y := scrollbox1.VertScrollBar.scrollpos-scrollbox1.top;
        BitMapImage := Scratchpicture1;
      end;
     reference:  begin
          scrollmove.x := scrollbox2.HorzScrollBar.scrollpos-scrollbox2.left;
          scrollmove.y := scrollbox2.VertScrollBar.scrollpos-scrollbox2.top;
          BitMapImage := Scratchpicture2;
      end;
   end;
   {now convert mouse position to relative to canvas origin}
   Mouselocale.X := Mouselocale.X + scrollmove.x;
   Mouselocale.Y := Mouselocale.Y + scrollmove.y;
   Repeat TempModal:= Form3.showmodal until ((Tempmodal = mrCancel) or (Tempmodal = mrYes) or (Tempmodal = mrNo));
   localclicktype := Form3.whichbut;
   if localclicktype<>neither then
      begin
        {update edit and consequent fields}
        case localclicktype of
          blue : begin
            SpectralData^.xminpixel := Mouselocale.X;
            SpectralData^.yminpixel := Mouselocale.Y;
            SpectralData^.Specinputs[2]^.Text := InttoSTR(Mouselocale.X) ;
            SpectralData^.SpecInputs[3]^.Text := InttoSTR(Mouselocale.Y) ;
          end;
          red :  begin
            SpectralData^.xmaxpixel := Mouselocale.X;
            SpectralData^.ymaxpixel := Mouselocale.Y;
            SpectralData^.Specinputs[4]^.Text := InttoSTR(Mouselocale.X) ;
            SpectralData^.SpecInputs[5]^.Text := InttoSTR(Mouselocale.Y) ;
          end;
        end;
        {call drawing routine}
        DrawSpecGuide(BitMapImage, ActiveImage, SpectralData);
      end;
end;

procedure TForm1.Print1Click(Sender: TObject);
var
  AspectRatio: Single;
  OutputWidth, OutputHeight : Single;
begin
  if not PrintDialog1.Execute then Exit;
  Printer.BeginDoc;
  Try
    {fill in later}
    ShowMessage('Printing not yet coded.  Sorry, this is beta software.  Printing from graphics window may work.');
  Finally
    Printer.EndDoc;
  End;
end;

procedure TForm1.PrintSetup1Click(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;

procedure TForm1.Openfile(const filename:string; Whichone: TSpecImData);

var
  tempimage : TJPegImage;
begin
  case Whichone of
    sample: begin
            Try
              begin
                { ScratchPicture1.LoadFromFile(Filename); }
                Image1.Picture.LoadFromFile(Filename);
              end;
            except
              on EInvalidGraphic do Image1.Picture.Graphic := nil;
            end;
              if (IMage1.Picture.Graphic <> nil) and (Image1.Picture.graphic is TJpegImage) then
                begin
                  tempimage := TJPegImage.create;
                  try
                    tempimage.assign(Image1.Picture.graphic);
                    Image1.picture.Bitmap.assign(tempimage);
                  finally
                    Freeandnil(tempimage);
                  end;
                  ScratchPicture1.Assign(Image1.Picture.Bitmap);
                  Pic1Loaded := true;
                  SampleSpectrum.Speccurrent := false;
                  FormAnImage(Whichone) ; {make Image1 with overlay}
                  button1.Enabled := true;
                  button2.Enabled := true;
                end
                else
                  begin
                    ShowMessage('When is a JPG not a JPG?');
                    Pic1Loaded := false;
                  end;
           end;
    reference: begin
               Try
                 begin
                  {Scratchimage2.Picture.LoadFromFile(Filename);  }
                  Image2.Picture.LoadFromFile(Filename);
                 end;
               except
                 on EInvalidGraphic do Image2.Picture.Graphic := nil;
               end;
              if (IMage2.Picture.Graphic <> nil) and (Image2.Picture.graphic is TJpegImage) then
                begin
                  tempimage := TJPegImage.create;
                  try
                    tempimage.assign(Image2.Picture.graphic);
                    Image2.picture.Bitmap.assign(tempimage);
                  finally
                    Freeandnil(tempimage);
                  end;
                  ScratchPicture2.Assign(Image2.Picture.Bitmap);
                  Pic2Loaded := true;
                  FormAnImage(Whichone) ; {make Image1 with overlay}
                  button1.Enabled := true;
                  button2.Enabled := true;
                  Referencespectrum.Speccurrent := false;
                end
                else
                  begin
                    ShowMessage('When is a JPG not a JPG?');
                    Pic2Loaded := false;
                  end;
    end;
  end;
end;

procedure TForm1.DrawSpecGuide(UnMarkedPicture : Tbitmap; DestIm : TImage; SpectralData : PSpectrum);

const
  RectSizeSpec = 4; {half size of square box}

begin
  SpectralData.Speccurrent := false;
  DestIm.Canvas.Draw(0,0,UnMarkedPicture);
  {ensure drawing is legal}
  if (SpectralData.xmaxpixel<=UnmarkedPicture.width) and (SpectralData.ymaxpixel<=UnmarkedPicture.height) then
    begin
  {draw red and blue boxes}
      DestIm.Canvas.Brush.style := bsclear;
      DestIm.Canvas.Pen.Color := clRed;
      DestIm.Canvas.Rectangle(SpectralData.xmaxpixel-RectSizeSpec,SpectralData.ymaxpixel-RectSizeSpec,
        SpectralData.xmaxpixel+RectSizeSpec,SpectralData.ymaxpixel+RectSizeSpec);
      DestIm.Canvas.Pen.Color := clBlue;
      DestIm.Canvas.Rectangle(SpectralData.xminpixel-RectSizeSpec,SpectralData.yminpixel-RectSizeSpec,
        SpectralData.xminpixel+RectSizeSpec,SpectralData.yminpixel+RectSizeSpec);
  {draw line between boxes}
      DestIm.Canvas.Pen.color := clLime;
      DestIm.Canvas.MoveTo(SpectralData.xminpixel,SpectralData.yminpixel);
      DestIm.Canvas.LineTo(SpectralData.xmaxpixel,SpectralData.ymaxpixel);
      if SpectralData.pixheight>4 then
         begin
           {draw lines on either side of spec centerline}
           DestIm.Canvas.Pen.Color := clGreen;
           if (ABS(SpectralData.xmaxpixel-SpectralData.xminpixel)>
               ABS(SpectralData.ymaxpixel-SpectralData.yminpixel)) then
               begin
                 DestIm.Canvas.MoveTo(SpectralData.xminpixel,SpectralData.yminpixel-SpectralData.pixheight div 2);
                 DestIm.Canvas.LineTo(SpectralData.xmaxpixel,SpectralData.ymaxpixel-SpectralData.pixheight div 2);
                 DestIm.Canvas.MoveTo(SpectralData.xminpixel,SpectralData.yminpixel+SpectralData.pixheight div 2);
                 DestIm.Canvas.LineTo(SpectralData.xmaxpixel,SpectralData.ymaxpixel+SpectralData.pixheight div 2);
               end
           else
               begin
                 DestIm.Canvas.MoveTo(SpectralData.xminpixel-SpectralData.pixheight div 2,SpectralData.yminpixel);
                 DestIm.Canvas.LineTo(SpectralData.xmaxpixel-SpectralData.pixheight div 2,SpectralData.ymaxpixel);
                 DestIm.Canvas.MoveTo(SpectralData.xminpixel+SpectralData.pixheight div 2,SpectralData.yminpixel);
                 DestIm.Canvas.LineTo(SpectralData.xmaxpixel+SpectralData.pixheight div 2,SpectralData.ymaxpixel);
               end;
         end;
    end
  else  begin
    ShowMessage('Not showing spectrum location in image.  Current drawing parameters exceed image size.  Please retry setting spectrum location.');
  end;
  DestIm.Repaint;
end;

procedure Tform1.FormAnImage(whichone: TSpecImData);

begin
  case whichone of
    sample: begin
      SpecAlignReconcile(sample);
      if Pic1Loaded then
         DrawSpecGuide(scratchpicture1,Image1,@SampleSpectrum);
    end;
    reference: begin
      SpecAlignReconcile(reference);
      If Pic2Loaded then
         DrawSpecGuide(scratchpicture2,Image2,@ReferenceSpectrum);
    end;
  end;
end;

procedure Tform1.SpecAlignReconcile(whichone : TSpecImData);

begin
  case whichone of
     sample : begin
       With SampleSpectrum do
         begin
           MinLambda := STRtoFloat(SpecInputs[0]^.text);
           MaxLambda := STRtoFloat(SpecInputs[1]^.text);
           xminpixel := STRtoINT(SpecInputs[2]^.text);
           yminpixel := STRtoINT(SpecInputs[3]^.text);
           xmaxpixel := STRtoINT(SpecInputs[4]^.text);
           ymaxpixel := STRtoINT(SpecInputs[5]^.text);
           pixheight := STRtoINT(SpecInputs[6]^.text);
           {Set graphics, then regenerate plot}
         end;
     end;
     reference : begin
       With ReferenceSpectrum do
         begin
           MinLambda := STRtoFloat(SpecInputs[0]^.text);
           MaxLambda := STRtoFloat(SpecInputs[1]^.text);
           xminpixel := STRtoINT(SpecInputs[2]^.text);
           yminpixel := STRtoINT(SpecInputs[3]^.text);
           xmaxpixel := STRtoINT(SpecInputs[4]^.text);
           ymaxpixel := STRtoINT(SpecInputs[5]^.text);
           pixheight := STRtoINT(SpecInputs[6]^.text);
           {Set graphics, then regenerate plot}
         end;
     end;
  end;
end;

procedure TForm1.UpDown1ChangingEx(Sender: TObject; var AllowChange: Boolean;
  NewValue: Smallint; Direction: TUpDownDirection);
begin
  ReferenceSpectrum.pixheight := STRtoINT(Edit7.text) ;
  SampleSpectrum.pixheight := ReferenceSpectrum.pixheight;
end;

function Tform1.ValIntRange(Sender: TObject; itarget, imin, imax: integer) : Boolean;

var
  TempInt, errorcode : integer;
begin
  VAL(TEdit(Sender).text, TempInt, errorcode);
  if errorcode<>0 then
    begin
      ShowMessage('Input must be an integer in the range '+ InttoSTR(imin)
      + ' to '+InttoSTR(imax)+'.  Please re-enter.');
      valintrange := false;
    end
  else
    begin
      if TempInt<imin then
        begin
          TempInt := imin;
          ShowMessage ('Entered value below allowed minimum of '+InttoSTR(imin)
          +'.  Setting to allowed minimum.');
        end
        else
          if TempInt>imax then
            begin
              TempInt := imax;
              ShowMessage ('Entered value above allowed maximum of '+InttoSTR(imax)
              +'.  Setting to allowed maximum.');
            end;
      TEdit(Sender).text := InttoSTR(TempInt);
      itarget := TempInt;
      ValIntRange := true;
    end;
end;

function Tform1.ValFloatRange(Sender: TObject; rtarget, rmin, rmax: real) : Boolean;

var
  TempReal : real;
  errorcode : integer;
begin
  VAL(TEdit(Sender).text, TempReal, errorcode);
  if errorcode<>0 then
    begin
      ShowMessage('Input must be a real number in the range '+ FloattoSTRF(rmin,fffixed, 4,1)
      + ' to '+FloattoSTRF(rmax,fffixed, 4,1)+'.  Please re-enter.');
      valFloatrange := false;
    end
  else
    begin
      if Tempreal<rmin then
        begin
          Tempreal := rmin;
          ShowMessage('Entered value below allowed minimum of '+FloattoSTRF(rmin,fffixed, 4,1)
          +'.  Setting to allowed minimum.');
        end
      else
       if Tempreal>rmax then
          begin
            Tempreal := rmax;
            ShowMessage('Entered value above allowed maximum of '+FloattoSTRF(rmax,fffixed, 4,1)
             +'.  Setting to allowed maximum.');
        end;
      rtarget := Tempreal;
      TEdit(Sender).text := FloattoSTRF(rtarget,fffixed, 4,1);
      ValFloatRange := true;
    end;
end;
end.
